import 'dart:convert';

BookingStatisticResponse bookingCountStatisticResponseFromMap(String str) => BookingStatisticResponse.fromMap(json.decode(str));

String bookingCountStatisticResponseToMap(BookingStatisticResponse data) => json.encode(data.toMap());

class BookingStatisticResponse {
  num? totalCount;
  num? totalPrice;
  Booked? newBooked;
  Booked? booked;
  Booked? progress;
  Booked? canceled;
  Booked? ended;
  Group? group;

  BookingStatisticResponse({
    this.totalCount,
    this.totalPrice,
    this.newBooked,
    this.booked,
    this.progress,
    this.canceled,
    this.ended,
    this.group,
  });

  BookingStatisticResponse copyWith({
    num? totalCount,
    num? totalPrice,
    Booked? newBooked,
    Booked? booked,
    Booked? progress,
    Booked? canceled,
    Booked? ended,
    Group? group,
  }) =>
      BookingStatisticResponse(
        totalCount: totalCount ?? this.totalCount,
        totalPrice: totalPrice ?? this.totalPrice,
        newBooked: newBooked ?? this.newBooked,
        booked: booked ?? this.booked,
        progress: progress ?? this.progress,
        canceled: canceled ?? this.canceled,
        ended: ended ?? this.ended,
        group: group ?? this.group,
      );

  factory BookingStatisticResponse.fromMap(Map<String, dynamic> json) => BookingStatisticResponse(
    totalCount: json["total_count"],
    totalPrice: json["total_price"],
    newBooked: json["new"] == null ? null : Booked.fromMap(json["new"]),
    booked: json["booked"] == null ? null : Booked.fromMap(json["booked"]),
    progress: json["progress"] == null ? null : Booked.fromMap(json["progress"]),
    canceled: json["canceled"] == null ? null : Booked.fromMap(json["canceled"]),
    ended: json["ended"] == null ? null : Booked.fromMap(json["ended"]),
    group: json["group"] == null ? null : Group.fromMap(json["group"]),
  );

  Map<String, dynamic> toMap() => {
    "total_count": totalCount,
    "total_price": totalPrice,
    "new": newBooked?.toMap(),
    "booked": booked?.toMap(),
    "progress": progress?.toMap(),
    "canceled": canceled?.toMap(),
    "ended": ended?.toMap(),
    "group": group?.toMap(),
  };
}

class Booked {
  num? count;
  num? percent;
  num? totalPrice;

  Booked({
    this.count,
    this.percent,
    this.totalPrice,
  });

  Booked copyWith({
    num? count,
    num? percent,
    num? totalPrice,
  }) =>
      Booked(
        count: count ?? this.count,
        percent: percent ?? this.percent,
        totalPrice: totalPrice ?? this.totalPrice,
      );

  factory Booked.fromMap(Map<String, dynamic> json) => Booked(
    count: json["count"],
    percent: json["percent"],
    totalPrice: json["total_price"],
  );

  Map<String, dynamic> toMap() => {
    "count": count,
    "percent": percent,
    "total_price": totalPrice,
  };
}

class Group {
  Active? active;
  Active? ended;

  Group({
    this.active,
    this.ended,
  });

  Group copyWith({
    Active? active,
    Active? ended,
  }) =>
      Group(
        active: active ?? this.active,
        ended: ended ?? this.ended,
      );

  factory Group.fromMap(Map<String, dynamic> json) => Group(
    active: json["active"] == null ? null : Active.fromMap(json["active"]),
    ended: json["ended"] == null ? null : Active.fromMap(json["ended"]),
  );

  Map<String, dynamic> toMap() => {
    "active": active?.toMap(),
    "ended": ended?.toMap(),
  };
}

class Active {
  int? count;
  int? percent;

  Active({
    this.count,
    this.percent,
  });

  Active copyWith({
    int? count,
    int? percent,
  }) =>
      Active(
        count: count ?? this.count,
        percent: percent ?? this.percent,
      );

  factory Active.fromMap(Map<String, dynamic> json) => Active(
    count: json["count"],
    percent: json["percent"],
  );

  Map<String, dynamic> toMap() => {
    "count": count,
    "percent": percent,
  };
}
